% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSBSumm.R
\name{BSBSumm}
\alias{BSBSumm}
\title{Get posterior summaries for BSBHaz model}
\usage{
BSBSumm(
  bsbhaz,
  variable = c("omega1", "omega2", "lambda1", "lambda2", "gamma", "theta", "s1", "s2")
)
}
\arguments{
\item{bsbhaz}{An object of class 'BSBHaz' created by
\code{\link{BSBHaz}}.}

\item{variable}{A character indicating which variable to get summaries from.}
}
\value{
A data frame with posterior sample means and a 95 \% probability
  interval. For \code{omega1}, \code{omega2}, \code{gamma}, and \code{theta}
  also includes a column with the acceptance rates for the
  Metropolis-Hastings algorithm.
}
\description{
Get posterior summaries for BSBHaz model
}
\examples{
t1 <- survival::Surv(c(1, 2, 3))
t2 <- survival::Surv(c(1, 2, 3))

init <- BSBInit(t1 = t1, t2 = t2, seed = 0)
samples <- BSBHaz(init, iter = 10, omega_d = 2,
gamma_d = 10, seed = 10)

BSBSumm(samples, variable = "gamma")
BSBSumm(samples, variable = "omega1")
BSBSumm(samples, variable = "lambda1")
}
