% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_belief_var.R
\name{prior_belief_var}
\alias{prior_belief_var}
\title{Prior Belief Graphical VAR}
\usage{
prior_belief_var(
  Y,
  prior_temporal = NULL,
  post_odds_cut = 3,
  est_ggm = TRUE,
  prior_ggm = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{Y}{Matrix (or data frame) of dimensions \emph{n}
(observations) by \emph{p} (variables/nodes).}

\item{prior_temporal}{Matrix of dimensions \emph{p} by \emph{p},
encoding the prior odds for including each relation
in the temporal graph (see '\code{Details}'). If null
a matrix of 1's is used, resulting in equal prior odds.}

\item{post_odds_cut}{Numeric. Threshold for including an edge (defaults to 3).
Note \code{post_odds} refers to posterior odds.}

\item{est_ggm}{Logical. Should the contemporaneous network be estimated
(defaults to \code{TRUE})?}

\item{prior_ggm}{Matrix of dimensions \emph{p} by \emph{p}, encoding the prior
odds for including each relation in the graph
(see '\code{Details}'). If null a matrix of 1's is used,
resulting in equal prior odds.}

\item{progress}{Logical. Should a progress bar be included
(defaults to \code{TRUE}) ?}

\item{...}{Additional arguments passed to \code{\link{explore}}. Ignored
if \code{prior_ggm = FALSE}.}
}
\value{
An object including (\code{est_ggm = FALSE}):

\itemize{

\item{\strong{adj}}: Adjacency matrix

\item{\strong{post_prob}}: Posterior probability for the
                           alternative hypothesis.

}

An object including (\code{est_ggm = TRUE}):
\itemize{

\item{\strong{adj_temporal}}: Adjacency matrix for the temporal network.

\item{\strong{post_prob_temporal}}: Posterior probability for the
                                    alternative hypothesis (temporal edge)

\item{\strong{adj_ggm}}: Adjacency matrix for the contemporaneous
                         network (ggm).

\item{post_prob_ggm}: Posterior probability for the
                      alternative hypothesis (contemporaneous edge)
}
}
\description{
Prior Belief Graphical VAR
}
\details{
Technically, the prior odds is not for including an edge in the graph,
but for (H1)/p(H0), where H1 captures the hypothesized edge size and H0 is the
null model  \insertCite{@see Williams2019_bf}{BGGM}. Accordingly, setting an
entry in \code{prior_ggm} to, say, 10, encodes a prior belief that H1 is 10 times
more likely than H0. Further, setting an entry in \code{prior_ggm} or
\code{prior_var} to 1 results in equal prior odds
(the default in \code{\link{select.explore}}).
}
\note{
The returned matrices are formatted with the rows indicating
the outcome and the columns the predictor. Hence, adj_temporal[1,4] is the temporal
relation of node 4 predicting node 1. This follows the convention of the
\strong{vars} package (i.e., \code{Acoef}).

Further, in order to compute the Bayes factor the data is
standardized (mean = 0 and standard deviation = 1).
}
\examples{
\donttest{
# affect data from 1 person
# (real data)
y <- na.omit(subset(ifit, id == 1)[,2:7])
p <- ncol(y)

# random prior graph
# (dont do this in practice!!)
prior_var = matrix(sample(c(1,10),
                   size = p^2, replace = TRUE),
                   nrow = p, ncol = p)

# fit model
fit <- prior_belief_var(y,
                        prior_temporal = prior_var,
                        post_odds_cut = 3)
}
}
