% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.estimate.R
\name{coef.estimate}
\alias{coef.estimate}
\title{Compute Regression Parameters for \code{estimate} Objects}
\usage{
\method{coef}{estimate}(object, iter = NULL, progress = TRUE, ...)
}
\arguments{
\item{object}{An Object of class \code{estimate}}

\item{iter}{Number of iterations (posterior samples; defaults to the number in the object).}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{coef}, containting two lists.


\itemize{

\item \code{betas} A list of length \emph{p}, each containing a \emph{p} - 1 by \code{iter} matrix of
posterior samples

\item \code{object} An object of class \code{estimate} (the fitted model).
}
}
\description{
There is a direct correspondence between the inverse covariance matrix and
 multiple regression \insertCite{kwan2014regression,Stephens1998}{BGGM}. This readily allows
 for converting the GGM parameters to regression coefficients. All data types are supported.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

#########################
### example 1: binary ###
#########################
# data
Y <- women_math[1:500, ]

# fit model
fit <- estimate(Y, type = "binary",
                iter = 250,
                progress = FALSE)

# summarize the partial correlations
reg <- coef(fit, progress = FALSE)

# summary
summ <- summary(reg)

summ
}
}
\references{
\insertAllCited{}
}
