% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfs_get_catalog_data.R
\name{bfs_get_catalog_data}
\alias{bfs_get_catalog_data}
\title{Get the BFS data catalog}
\usage{
bfs_get_catalog_data(
  language = "de",
  title = NULL,
  extended_search = NULL,
  spatial_division = NULL,
  prodima = NULL,
  inquiry = NULL,
  institution = NULL,
  publishing_year_start = NULL,
  publishing_year_end = NULL,
  order_nr = NULL,
  limit = 1000,
  article_model = 900033,
  article_model_group = 900029
)
}
\arguments{
\item{language}{character The language of a BFS catalog, i.e. "de", "fr", "it" or "en".}

\item{title}{character String to search in (sub/super)title}

\item{extended_search}{character String for an extended search in (sub/super)title, orderNr, summary, shortSummary, shortTextGNP}

\item{spatial_division}{BFS datasets by spatial division, choose between "Switzerland", "Cantons", "Districts", "Communes", "Other spatial divisions" or "International"}

\item{prodima}{numeric Get only specific BFS themes using one or multiple prodima numbers}

\item{inquiry}{character BFS datasets for an inquiry}

\item{institution}{character BFS datasets for an institution}

\item{publishing_year_start}{character BFS datasets for a publishing year start}

\item{publishing_year_end}{character BFS datasets for a publishing year end}

\item{order_nr}{character Filter by BFS Number (FSO number)}

\item{limit}{integer limit of query results (1000 by default)}

\item{article_model}{integer articleModel parameter query}

\item{article_model_group}{integer articleModel parameter query}
}
\value{
A data frame. Returns NULL if no connection.

A tbl_df (a type of data frame; see tibble or
dplyr packages). Returns NULL if no connection.
}
\description{
Get the list of the data available in the official DAM-API of the Swiss Federal Statistical Office asset catalog.
}
\examples{
\donttest{
bfs_get_catalog_data(language = "en", title = "students", prodima = c(900212))
}

}
\seealso{
\code{\link{bfs_get_data}}

\describe{
  \item{title}{A character column with the title of the BFS dataset}
  \item{language}{A character column with the language of the BFS dataset}
  \item{publication_date}{The published date of the BFS dataset in the data catalog}
  \item{number_asset}{The BFS asset number}
  \item{url_px}{A character column with the URL of the PX file}
}
}
