% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETS.t_test.R
\name{BETS.t_test}
\alias{BETS.t_test}
\title{Test the significance of the parameters of an ARIMA model}
\usage{
BETS.t_test(model, nx = 0, alpha = 0.05)
}
\arguments{
\item{model}{An \link[forecast]{Arima} or an \link[stats]{arima} object. The model for which the parameters must be tested.}

\item{nx}{An \code{integer}. The number of exogenous variables}

\item{alpha}{A \code{numeric} value between 0 and 1. The significance level.}
}
\value{
A \code{data.frame} containing the standard erros, the t-statistic, the critical values and whether the null hypothesis should be rejected or not, for each model parameter.
}
\description{
Performs the t test on every parameter of an ARIMA model. This model can be an \link[forecast]{Arima} or an \link[stats]{arima}.
}
\examples{
require(forecast)
data("AirPassengers")
fit.air<- Arima(AirPassengers,order = c(1,1,1), seasonal = c(1,1,1), method ="ML",lambda=0)
summary(fit.air)

# Significance test for the model SARIMA(1,1,1)(1,1,1)[12]
BETS.t_test(model = fit.air)


}
\author{
Talitha Speranza \email{talitha.speranza@fgv.br}, Daiane Marcolino \email{daiane.mattos@fgv.br}
}
