% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{focusOnScope}
\alias{focusOnScope}
\title{Focus a BE related object on a specific identifier (BEID) scope}
\usage{
focusOnScope(
  x,
  be,
  source,
  organism,
  scope,
  force,
  restricted,
  prefFilter,
  ...
)
}
\arguments{
\item{x}{an object representing a collection of BEID (e.g. BEIDList)}

\item{be}{the type of biological entity to focus on.
Used if \code{is.null(scope)}}

\item{source}{the source of BEID to focus on.
Used if \code{is.null(scope)}}

\item{organism}{the organism of BEID to focus on.
Used if \code{is.null(scope)}}

\item{scope}{a list with the following element:
\itemize{
\item \strong{be}
\item \strong{source}
\item \strong{organism}
}}

\item{force}{if TRUE the conversion is done even between identical scopes
(default: FALSE)}

\item{restricted}{if TRUE (default) the BEID are limited to current version
of the source}

\item{prefFilter}{if TRUE (default) the BEID are limited to prefered
identifiers when they exist}

\item{...}{method specific parameters for BEID conversion}
}
\value{
Depends on the class of x
}
\description{
Focus a BE related object on a specific identifier (BEID) scope
}
