% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mixedAn.R
\name{summary.mixedAn}
\alias{summary.mixedAn}
\title{Summary Methods For Objects in the Class \code{mixedAn} (Mixed Analysis)}
\usage{
\method{summary}{mixedAn}(object, wtp = 25000, ...)
}
\arguments{
\item{object}{An object of the class \code{mixedAn}, which is the results of
the function \code{\link{mixedAn}}, generating the economic evaluation of a
set of interventions, considering given market shares for each option.}

\item{wtp}{The value of the willingness to pay choosen to present the
analysis.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
Produces a table with summary information on the loss in expected
value of information generated by the inclusion of non cost-effective
interventions in the market.
}
\description{
Prints a summary table for the results of the mixed analysis for the
economic evaluation of a given model.
}
\examples{

# See Baio G., Dawid A.P. (2011) for a detailed description of the 
# Bayesian model and economic problem

# Load the processed results of the MCMC simulation model
data(Vaccine)

# Runs the health economic evaluation using BCEA
m <- bcea(e=e,c=c,          # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e,c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000            # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0,Kmax)
)

mixedAn(m) <- NULL      # uses the results of the mixed strategy 
                        #  analysis (a "mixedAn" object)
                        # the vector of market shares can be defined 
                        #  externally. If NULL, then each of the T 
                        #  interventions will have 1/T market share

# Prints a summary of the results
summary(m,         # uses the results of the mixed strategy analysis 
        wtp=25000) #  (a "mixedAn" object)
                   # selects the relevant willingness to pay 
                   #  (default: 25,000)

}
\references{
Baio, G. and Russo, P. (2009). A decision-theoretic framework for
the application of cost-effectiveness analysis in regulatory processes.
Pharmacoeconomics 27(8), 645-655 doi:10.2165/11310250

Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity Analysis in Health
Economics. Statistical Methods in Medical Research
doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London.
}
\seealso{
\code{\link{bcea}},
         \code{\link{mixedAn}}
}
\author{
Gianluca Baio
}
\keyword{Health}
\keyword{Mixed}
\keyword{analysis}
\keyword{economic}
\keyword{evaluation}
