% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bubble_plot.R
\name{get_bubble_plot}
\alias{get_bubble_plot}
\title{Basketball bubble plot}
\usage{
get_bubble_plot(df_stats, player)
}
\arguments{
\item{df_stats}{Data frame with the statistics.}

\item{player}{Player.}
}
\value{
Graphical device
}
\description{
This plot is a representation of the percentiles of all statistics 
for a particular player. The figure shows four cells. The first box 
contains the percentiles between 0 and 24. The second, between 25 and 49. 
The third, between 50 and 74 and the fourth, between 75 and 100. The
percentiles are computed with the function 
\code{\link[Anthropometry]{percentilsArchetypoid}}.

This type of visualization allows the user to analyze each player in a very 
simple way, since a general idea of those aspects of the game in which the 
player excels can be obtained.
}
\details{
In the example shown below, it can be seen that Alberto Abalde has a percentile of 
x in free throws percentage. This means that the x percent of league players has a fewer 
percentage than him, while there is a (100-x) percent who has a bigger percentage.
}
\examples{
\dontrun{
compet <- "ACB"
df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)
df2 <- do_stats(df1, "Total", "2017-2018", compet, "Regular Season")
get_bubble_plot(df2, "Abalde, Alberto")
}

}
\seealso{
\code{\link[Anthropometry]{percentilsArchetypoid}}
}
\author{
This function has been created using the code of this website:
\url{https://www.r-bloggers.com/visualizing-the-best/}.
}
