% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_records.R
\name{refuel}
\alias{refuel}
\title{Add new processed records from Bath: Hacked datastore}
\usage{
refuel(x, max_prop = 1.1, first_upload = FALSE)
}
\arguments{
\item{x}{The result of calling \code{\link{refine}} on the data frame of
records from the Bath: Hacked datastore (see \code{\link{get_all_crude}}).}

\item{max_prop, first_upload}{See \code{\link{refine}}.}
}
\value{
The data frame updated with any more recent records.
}
\description{
Update data frame of records already processed with \code{\link{refine}} with
 any records that have since been added to the Bath: Hacked datastore.
}
\examples{
\donttest{
raw_data <- get_all_crude()
df <- refine(get_all_crude)

# Some time later, add most recent records
df <- refuel(df)
}
}
\seealso{
\itemize{
 \item \code{\link{get_all_crude}} for obtaining data frame of raw records
 \item \code{\link{refuel_crude}} for updating data frame of raw records
}
}
