% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMeanBranchLengthTree.R
\name{getMeanBranchLengthTree}
\alias{getMeanBranchLengthTree}
\title{Compute phylogeny with branch lengths equal to corresponding
    macroevolutionary rate estimates}
\usage{
getMeanBranchLengthTree(ephy, rate = "speciation")
}
\arguments{
\item{ephy}{An object of class \code{bammdata}.}

\item{rate}{The type of rate-tree to be computed. Options: "speciation"
(default), "extinction", "ndr" (net diversification), and "trait".}
}
\value{
A list with the following components:
    \itemize{
        \item{phy} {A phylogenetic tree, topologically identical to the
            model tree, but with branch lengths replaced by the mean
            (marginal) rates on each branch as estimated from the
            posterior samples in the \code{bammdata} object.}
        \item{mean} {The mean rate over all branches.}
        \item{median} {the median rate over all branches.}
    }
}
\description{
Takes a \code{bammdata} object and computes a phylogenetic
    tree where branch lengths are equal to the mean of the marginal
    distributions of rates on each branch. This tree can be plotted to
    visualize rate variation across a phylogeny.
}
\examples{
data(whales)
data(events.whales)
ed <- getEventData(whales, events.whales, burnin=0.1, nsamples=500)
ed2 <- subsetEventData(ed, index = 1:20)
ratetree <- getMeanBranchLengthTree(ed2, rate='speciation')
plot(ratetree$phy, show.tip.label=FALSE)
}
\author{
Dan Rabosky
}
\references{
\url{http://bamm-project.org}
}
\seealso{
\code{\link{plot.bammdata}}
}
\keyword{models}

