% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_model_plots.R
\name{surface_model}
\alias{surface_model}
\title{Surface for bivariate angular mixture model densities}
\usage{
surface_model(
  model = "vmsin",
  kappa1,
  kappa2,
  kappa3,
  mu1,
  mu2,
  pmix = rep(1/length(kappa1), length(kappa1)),
  xpoints = seq(0, 2 * pi, length.out = 30),
  ypoints = seq(0, 2 * pi, length.out = 30),
  log.density = FALSE,
  xlab = "x",
  ylab = "y",
  zlab = ifelse(log.density, "Log Density", "Density"),
  main,
  ...
)
}
\arguments{
\item{model}{bivariate angular model whose mixture is of interest. Must be one of
"vmsin", "vmcos" and "wnorm2".}

\item{kappa1, kappa2, kappa3, mu1, mu2, pmix}{model parameters and mixing
proportions. See the respective mixture model densities (\link{dvmsinmix}, \link{dvmcosmix},
\link{dwnorm2mix}) for more details.}

\item{xpoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{ypoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{log.density}{logical. Should log density be used for the plot?}

\item{xlab, ylab, zlab, main}{graphical parameters passed to \code{lattice::wireframe}}

\item{...}{additional arguments passed to \code{lattice::wireframe}}
}
\description{
Surface for bivariate angular mixture model densities
}
\examples{
surface_model('vmsin', 1, 1, 1.5, pi, pi)
surface_model('vmcos', 1, 1, 1.5, pi, pi)

}
