% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmss_config.R
\name{scaleset_options}
\alias{scaleset_options}
\title{Virtual machine scaleset options}
\usage{
scaleset_options(keylogin = TRUE, managed = TRUE, public = FALSE,
  low_priority = FALSE, delete_on_evict = FALSE,
  network_accel = FALSE, large_scaleset = FALSE,
  overprovision = TRUE, upgrade_policy = list(mode = "manual"))
}
\arguments{
\item{keylogin}{Whether to use an SSH public key to login (TRUE) or a password (FALSE). Note that Windows does not support SSH key logins.}

\item{managed}{Whether to provide a managed system identity for the VM.}

\item{public}{Whether the instances (nodes) of the scaleset should be visible from the public internet.}

\item{low_priority}{Whether to use low-priority VMs. Note that this option is only available for certain VM sizes.}

\item{delete_on_evict}{If low-priority VMs are being used, whether evicting (shutting down) a VM should delete it, as opposed to just deallocating it.}

\item{network_accel}{Whether to enable accelerated networking. This option is only available for certain VM sizes.}

\item{large_scaleset}{Whether to enable scaleset sizes > 100 instances.}

\item{overprovision}{Whether to overprovision the scaleset on creation.}

\item{upgrade_policy}{A list, giving the VM upgrade policy for the scaleset.}
}
\description{
Virtual machine scaleset options
}
