% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{create_vm}
\alias{create_vm}
\alias{create_vm_cluster}
\title{Create a new virtual machine or cluster of virtual machines}
\description{
Method for the \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} and \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'az_resource_group'
create_vm(name, os = c("Windows", "Ubuntu"), size = "Standard_DS3_v2",
          username, passkey, userauth_type = c("password", "key"),
          ext_file_uris = NULL, inst_command = NULL,
          template, parameters, ..., wait = TRUE)

## R6 method for class 'az_subscription'
create_vm(name, location, os = c("Windows", "Ubuntu"), size = "Standard_DS3_v2",
          username, passkey, userauth_type = c("password", "key"),
          ext_file_uris = NULL, inst_command = NULL,
          template, parameters, ..., wait = TRUE)

## R6 method for class 'az_resource_group'
create_vm_cluster(name, os = c("Windows", "Ubuntu"), size = "Standard_DS3_v2",
                  username, passkey, userauth_type = c("password", "key"),
                  ext_file_uris = NULL, inst_command = NULL, clust_size,
                  template, parameters, ..., wait = TRUE)

## R6 method for class 'az_subscription'
create_vm_cluster(name, location, os = c("Windows", "Ubuntu"), size = "Standard_DS3_v2",
                  username, passkey, userauth_type = c("password", "key"),
                  ext_file_uris = NULL, inst_command = NULL, clust_size,
                  template, parameters, ..., wait = TRUE)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the VM or cluster.
\item \code{location}: For the subscription class methods, the location for the VM. Use the \code{list_locations()} method of the \code{AzureRMR::az_subscription} class to see what locations are available.
\item \code{os}: The operating system for the VM.
\item \code{size}: The VM size. Use the \code{list_vm_sizes()} method of the \code{AzureRMR::az_subscription} class to see what sizes are available.
\item \code{username}: The login username for the VM.
\item \code{passkey}: The login password or public key.
\item \code{userauth_type}: The type of login authentication to use. Only has an effect for Linux-based VMs; Windows VMs will always use \code{"password"}.
\item \code{ext_file_uris}: Optional link to download extension packages.
\item \code{inst_command}: If \code{ext_file_uris} is supplied, the install script to run. Defaults to \code{install.sh} for an Ubuntu VM, or \code{install.ps1} for a Windows VM.
\item \code{clust_size}: For a cluster, the number of nodes to create.
\item \code{template}: Optional: the VM template to deploy. By default, this is determined by the values of the other arguments; see 'Details' below.
\item \code{parameters}: Optional: other parameters to pass to the deployment.
\item \code{wait}: Whether to wait until the deployment is complete.
\item \code{...}: Other arguments to lower-level methods.
}
}

\section{Details}{

This method deploys a template to create a new virtual machine or cluster of VMs. Currently, seven templates are supplied with this package, based on the Azure Data Science Virtual Machine:
\itemize{
\item Ubuntu DSVM
\item Ubuntu DSVM using public key authentication
\item Ubuntu DSVM with extensions
\item Ubuntu DSVM cluster
\item Ubuntu DSVM cluster with extensions
\item Windows Server 2016 DSVM
\item Windows Server 2016 DSVM cluster with extensions
}

An individual virtual machine is treated as a cluster containing only a single node.

You can also supply your own VM template for deployment, via the \code{template} argument. See \link[AzureRMR:az_template]{AzureRMR::az_template} for information how to supply templates. Note that if you do this, you may also have to supply a \code{parameters} argument, as the standard parameters for this method are customised for the DSVM.

For the \code{AzureRMR::az_subscription} method, this will by default create the VM in \emph{exclusive} mode, meaning a new resource group is created solely to hold the VM. This simplifies managing the VM considerably, in particular deleting the resource group will also automatically delete all the VM's resources.
}

\section{Value}{

An object of class \code{az_vm_template} representing the created VM.
}

\examples{
\dontrun{

sub <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")

# default Windows Server DSVM: make sure to use a strong password!
sub$create_vm("myWindowsDSVM",
   location="australiaeast",
   username="ds",
   passkey="Password123!")

# upsized Linux (Ubuntu) DSVM
sub$create_vm("myLinuxDSVM",
   location="australiaeast",
   os="Linux",
   username="ds",
   passkey=readLines("~/id_rsa.pub"),
   size="Standard_DS13_v2")

sub$create_vm_cluster("myLinuxCluster",
   location="australiaeast",
   os="Linux",
   username="ds",
   passkey=readLines("~/id_rsa.pub"),
   clust_size=5)

}
}
\seealso{
\link{az_vm_template},
\link[AzureRMR:az_subscription]{AzureRMR::az_subscription}, \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group},
\href{https://azure.microsoft.com/en-us/services/virtual-machines/data-science-virtual-machines/}{Data Science Virtual Machine}
}
