% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl.R
\name{inner_join.tbl_kusto_abstract}
\alias{inner_join.tbl_kusto_abstract}
\alias{inner_join}
\alias{left_join}
\alias{right_join}
\alias{full_join}
\alias{semi_join}
\alias{anti_join}
\alias{left_join.tbl_kusto_abstract}
\alias{right_join.tbl_kusto_abstract}
\alias{full_join.tbl_kusto_abstract}
\alias{semi_join.tbl_kusto_abstract}
\alias{anti_join.tbl_kusto_abstract}
\title{Join methods for Kusto tables}
\usage{
\method{inner_join}{tbl_kusto_abstract}(x, y, by = NULL,
  suffix = c(".x", ".y"), .strategy = NULL, .shufflekeys = NULL,
  .num_partitions = NULL, .remote = NULL, ...)

\method{left_join}{tbl_kusto_abstract}(x, y, by = NULL,
  suffix = c(".x", ".y"), .strategy = NULL, .shufflekeys = NULL,
  .num_partitions = NULL, .remote = NULL, ...)

\method{right_join}{tbl_kusto_abstract}(x, y, by = NULL,
  suffix = c(".x", ".y"), .strategy = NULL, .shufflekeys = NULL,
  .num_partitions = NULL, .remote = NULL, ...)

\method{full_join}{tbl_kusto_abstract}(x, y, by = NULL,
  suffix = c(".x", ".y"), .strategy = NULL, .shufflekeys = NULL,
  .num_partitions = NULL, .remote = NULL, ...)

\method{semi_join}{tbl_kusto_abstract}(x, y, by = NULL,
  suffix = c(".x", ".y"), .strategy = NULL, .shufflekeys = NULL,
  .num_partitions = NULL, .remote = NULL, ...)

\method{anti_join}{tbl_kusto_abstract}(x, y, by = NULL,
  suffix = c(".x", ".y"), .strategy = NULL, .shufflekeys = NULL,
  .num_partitions = NULL, .remote = NULL, ...)
}
\arguments{
\item{x, y}{Kusto tbls.}

\item{by}{The columns to join on.}

\item{suffix}{The suffixes to use for deduplicating column names.}

\item{.strategy}{A join strategy hint to pass to Kusto. Currently the values supported are "shuffle" and "broadcast".}

\item{.shufflekeys}{A character vector of column names to use as shuffle keys.}

\item{.num_partitions}{The number of partitions for a shuffle query.}

\item{.remote}{A join strategy hint to use for cross-cluster joins. Can be "left", "right", "local" or "auto" (the default).}

\item{...}{Other arguments passed to lower-level functions.}
}
\description{
These methods are the same as other joining methods, with the exception of the \code{.strategy}, \code{.shufflekeys} and \code{.num_partitions} optional arguments. They provide hints to the Kusto engine on how to execute the join, and can sometimes be useful to speed up a query. See the Kusto documentation for more details.
}
\examples{
\dontrun{

tbl1 <- tbl_kusto(db, "table1")
tbl2 <- tbl_kusto(db, "table2")

# standard dplyr syntax:
left_join(tbl1, tbl2)

# Kusto extensions:
left_join(tbl1, tbl2, .strategy="broadcast") # a broadcast join

left_join(tbl1, tbl2, .shufflekeys=c("var1", "var2")) # shuffle join with shuffle keys

left_join(tbl1, tbl2, .num_partitions=5)     # no. of partitions for a shuffle join
}

}
\seealso{
\link[dplyr:join]{dplyr::join}
}
