% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_vault.R
\docType{class}
\name{az_key_vault}
\alias{az_key_vault}
\title{Key vault resource class}
\format{An object of class \code{R6ClassGenerator} of length 25.}
\usage{
az_key_vault
}
\description{
Class representing a key vault, exposing methods for working with it.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new key vault object. See 'Initialization'.
\item \code{add_principal(principal, ...)}: Add an access policy for a user or service principal. See 'Access policies' below.
\item \code{get_principal(principal)}: Retrieve an access policy for a user or service principal.
\item \code{remove_principal(principal)}: Remove access for a user or service principal.
\item \code{get_endpoint()}: Return the vault endpoint. See 'Endpoint' below.
}
}

\section{Initialization}{

Initializing a new object of this class can either retrieve an existing key vault, or create a new vault on the host. The recommended way to initialize an object is via the \code{get_key_vault}, \code{create_key_vault} or \code{list_key_vaults} methods of the \link{az_resource_group} class, which handle the details automatically.
}

\section{Access policies}{

Client access to a key vault is governed by its access policies, which are set on a per-principal basis. Each principal (user or service) can have different permissions granted, for keys, secrets, certificates, and storage accounts.

To grant access, use the \code{add_principal} method. This has signature\preformatted{add_principal(principal, tenant = NULL,
              key_permissions = "all",
              secret_permissions = "all",
              certificate_permissions = "all",
              storage_permissions = "all")
}

The \code{principal} can be a GUID, an object of class \code{vault_access_policy}, or a user, app or service principal object from the AzureGraph package. Note that the app ID of a registered app is not the same as the ID of its service principal.

The tenant must be a GUID; if this is NULL, it will be taken from the tenant of the key vault resource.

Here are the possible permissions for keys, secrets, certificates, and storage accounts. The permission "all" means to grant all permissions.
\itemize{
\item Keys: "get", "list", "update", "create", "import", "delete", "recover", "backup", "restore", "decrypt", "encrypt", "unwrapkey", "wrapkey", "verify", "sign", "purge"
\item Secrets: "get", "list", "set", "delete", "recover", "backup", "restore", "purge"
\item Certificates: "get", "list", "update", "create", "import", "delete", "recover", "backup", "restore", "managecontacts", "manageissuers", "getissuers", "listissuers", "setissuers", "deleteissuers", "purge"
\item Storage accounts: "get", "list", "update", "set", "delete", "recover", "backup", "restore", "regeneratekey", "getsas", "listsas", "setsas", "deletesas", "purge"
}

To revoke access, use the \code{remove_principal} method. To view the current access policy, use \code{get_principal} or \code{list_principals}.
}

\section{Endpoint}{

The client-side interaction with a key vault is via its \emph{endpoint}, which is usually at the URL \code{https://[vaultname].vault.azure.net}. The \code{get_endpoint} method returns an R6 object of class \code{key_vault}, which represents the endpoint. Authenticating with the endpoint is done via an OAuth token; the necessary credentials are taken from the current Resource Manager client in use, or you can supply your own.\preformatted{get_endpoint(tenant = self$token$tenant,
             app = self$token$client$client_id,
             password = self$token$client$client_secret, ...)
}

To access the key vault independently of Resource Manager (for example if you are a user without admin or owner access to the vault resource), use the \link{key_vault} function.
}

\examples{
\dontrun{

# recommended way of retrieving a resource: via a resource group object
kv <- resgroup$get_key_vault("mykeyvault")

# list principals that have access to the vault
kv$list_principals()

# grant a user full access (the default)
usr <- AzureGraph::get_graph_login()$
    get_user("username@aadtenant.com")
kv$add_principal(usr)

# grant a service principal read access to keys and secrets only
svc <- AzureGraph::get_graph_login()$
    get_service_principal(app_id="app_id")
kv$add_principal(svc,
    key_permissions=c("get", "list"),
    secret_permissions=c("get", "list"),
    certificate_permissions=NULL,
    storage_permissions=NULL)
# alternatively, supply a vault_access_policy with the listed permissions
pol <- vault_access_policy(svc,
    key_permissions=c("get", "list"),
    secret_permissions=c("get", "list"),
    certificate_permissions=NULL,
    storage_permissions=NULL)
kv$add_principal(pol)

# revoke access
kv$remove_access(svc)

# get the endpoint object
vault <- kv$get_endpoint()

}
}
\seealso{
\link{vault_access_policy}, \link{key_vault}
\link{create_key_vault}, \link{get_key_vault}, \link{delete_key_vault},
\link[AzureGraph:get_graph_login]{AzureGraph::get_graph_login}, \link[AzureGraph:az_user]{AzureGraph::az_user}, \link[AzureGraph:az_app]{AzureGraph::az_app}, \link[AzureGraph:az_service_principal]{AzureGraph::az_service_principal}

\href{https://docs.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://docs.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
\keyword{datasets}
