% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingfunctions.R
\name{plot_CGloc}
\alias{plot_CGloc}
\title{Plot the center of gravity of each component}
\usage{
plot_CGloc(
  clean_pts,
  mass_properties,
  mass_properties_skin,
  mass_properties_bone,
  mass_properties_feathers,
  mass_properties_muscle,
  prop_tertiary1,
  prop_tertiary2,
  plot_var
)
}
\arguments{
\item{clean_pts}{Dataframe of the key positions of the bird as follows:
\itemize{
\item{pt1x, pt1y, pt1z}{Point on the shoulder joint}
\item{pt2x, pt1y, pt2z}{Point on the elbow joint}
\item{pt3x, pt3y, pt3z}{Point on the wrist joint}
\item{pt4x, pt4y, pt4z}{Point on the end of carpometacarpus}
\item{pt6x, pt6y, pt6z}{Point on the leading edge of the wing in front of the
wrist joint}
\item{pt8x, pt8y, pt8z}{Point on tip of most distal primary}
\item{pt9x, pt9y, pt9z}{Point that defines the end of carpometacarpus}
\item{pt10x, pt10y, pt10z}{Point on tip of last primary to model as if on the
end of the carpometacarpus}
\item{pt11x, pt11y, pt11z}{Point on tip of most proximal feather
(wing root trailing edge)}
\item{pt12x, pt12y, pt12z}{Point on exterior shoulder position
(wing root leading edge)}
}}

\item{mass_properties}{Dataframe containing the center of gravity and
moment of inertia components of the full wing.}

\item{mass_properties_skin}{Dataframe containing the center of gravity and
moment of inertia components of the skin.
Formatted with the following columns: "species","BirdID","TestID","FrameID",
"prop_type","component","value".}

\item{mass_properties_bone}{Dataframe containing the center of gravity and
moment of inertia components of the wing bones.
Formatted with the following columns: "species","BirdID","TestID","FrameID",
"prop_type","component","value".}

\item{mass_properties_feathers}{Dataframe containing the center of gravity and
moment of inertia components of the feathers.
Formatted with the following columns: "species","BirdID","TestID","FrameID",
"prop_type","component","value".}

\item{mass_properties_muscle}{Dataframe containing the center of gravity and
moment of inertia components of the muscles
Formatted with the following columns: "species","BirdID","TestID","FrameID",
"prop_type","component","value".}

\item{prop_tertiary1}{Dataframe containing the center of gravity and
moment of inertia components of the first tertiary group.
Formatted with the following columns: "species","BirdID","TestID","FrameID",
"prop_type","component","value".}

\item{prop_tertiary2}{Dataframe containing the center of gravity and
moment of inertia components of the second tertiary group.
Formatted with the following columns: "species","BirdID","TestID","FrameID",
"prop_type","component","value".}

\item{plot_var}{Character of either "yx" or "yz".
Defines the output axes of the plot.}
}
\value{
A plot of the request axes
}
\description{
Plot the center of gravity of each component
}
\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
