% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmmTree.R
\name{wmmTree}
\alias{wmmTree}
\title{wmmTree}
\usage{
wmmTree(
  tree,
  sample_length = 10,
  method = "mmEstimate",
  int.type = "quants",
  single.source = FALSE
)
}
\arguments{
\item{tree}{A makeTree object}

\item{sample_length}{An integer for number of samples}

\item{method}{Method specifying weighting. Only default compatible with 'mmEstimate'
at this time}

\item{int.type}{A string specifying interval type. Default "quants" generates
the interval using the quantiles giving the central 95\% of the samples.
Alternatively, "var" can be used to generate a variance-weighted confidence
interval, and "cox" generates a Cox interval.}

\item{single.source}{Set to TRUE if all data comes from single, fully informed
source.  Default is FALSE.}
}
\value{
Returns a makeTree object with branches and nodes now associated with
 estimates and samples generated with the weighted multiplier method
}
\description{
Main function. Generate weighted estimates using the weighted
 multiplier method.
}
\examples{
\donttest{
  data(treeData1)
  tree <- makeTree(treeData1)
  Zhats <- wmmTree(tree, sample_length = 3)

  message("Another example with a larger tree")
  message("note - longer run time example")
  data(treeData2)
  tree2 <- makeTree(treeData2)
  Zhats <- wmmTree(tree2, sample_length = 3)
  Zhats$estimates # print the estimates of the root node generated by the 15 iterations
  Zhats$weights # prints the weights of each branch
  Zhats$root # prints the final estimate of the root node by WMM
  Zhats$uncertainty # prints the final rounded estimate of the root with conf. int.

  message(paste("show the average root estimate with 95\% confidence interval,",
          "as well as average estimates with confidence interval for each parameter"))
  tree2$Get('uncertainty')

  message("show the samples generated from each path which provides root estimates")
  tree2$Get('targetEst_samples')

  message("show the probabilities sampled at each branch leading into the given node")
  tree2$Get('probability_samples')
}
}
