% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{compute_descriptive_table}
\alias{compute_descriptive_table}
\title{AutoScore function: Descriptive Analysis}
\usage{
compute_descriptive_table(df, ...)
}
\arguments{
\item{df}{data frame after checking and fulfilling the requirement of AutoScore}

\item{...}{additional parameters to pass to
\code{\link[tableone]{print.TableOne}} and \code{\link[knitr]{kable}}.}
}
\value{
No return value and the result of the descriptive analysis will be printed out.
}
\description{
Compute descriptive table (usually Table 1 in the medical
  literature) for the dataset.
}
\examples{
data("sample_data")
names(sample_data)[names(sample_data) == "Mortality_inpatient"] <- "label"
compute_descriptive_table(sample_data)
# Report median and IQR (instead of default mean and SD) for Age, and add a
# caption to printed table:
compute_descriptive_table(sample_data, nonnormal = "Age",
                          caption = "Table 1. Patient characteristics")
}
