% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twodvarshape.R
\name{twodvarshape}
\alias{twodvarshape}
\title{twodvarshape 
Calculates the shape variation associated to a value of PC scores associated to a specific 2D view}
\usage{
twodvarshape(twodviews_ob, scores, PC, view)
}
\arguments{
\item{twodviews_ob}{object from twodviews()}

\item{scores}{numeric: the values of the PC scores for which the visualization is called}

\item{PC}{PC chosen}

\item{view}{numeric: 2D set to be used for shape variation visualization}
}
\value{
mat matrix of 2D coordinates associated to the called shape variation
}
\description{
twodvarshape 
Calculates the shape variation associated to a value of PC scores associated to a specific 2D view
}
\examples{
#load the 2D primate dataset
data("Lset2D_list")
#combine the 2D datasets and PCA
combin2D<-twodviews(Lset2D_list,scale=TRUE,vector=c(1:5))
#calculate the shape variation associated to the negative extreme value of PC1
min_PC1<-twodvarshape(combin2D,min(combin2D$PCscores[,1]),1,5)
plot(min_PC1,asp=1)
#calculate the shape variation associated to the positive extreme value of PC1
max_PC1<-twodvarshape(combin2D,max(combin2D$PCscores[,1]),1,5)
plot(max_PC1,asp=1)
}
\author{
Antonio Profico, Costantino Buzi, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
