% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sorting.R
\name{isSorted}
\alias{isSorted}
\alias{isSorted.data.frame}
\alias{isSorted.tbl_dbi}
\title{Check if data are sorted by one or more columns}
\usage{
isSorted(data, columnNames, ascending = rep(TRUE, length(columnNames)))

\method{isSorted}{data.frame}(data, columnNames, ascending = rep(TRUE, length(columnNames)))

\method{isSorted}{tbl_dbi}(data, columnNames, ascending = rep(TRUE, length(columnNames)))
}
\arguments{
\item{data}{Either a data frame or \code{\link{Andromeda}} table.}

\item{columnNames}{Vector of one or more column names.}

\item{ascending}{Logical vector indicating the data should be sorted ascending or
descending according the specified columns.}
}
\value{
\code{TRUE} or \code{FALSE}.
}
\description{
Checks whether data are sorted by one or more specified columns.
}
\details{
This function currently only supports checking for sorting on numeric values.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Check if a \code{data.frame} is sorted by one or more columns

\item \code{tbl_dbi}: Check if an \code{\link{Andromeda}} table is sorted by one or more columns
}}

\examples{
x <- data.frame(a = runif(1000), b = runif(1000))
x <- round(x, digits=2)
isSorted(x, c("a", "b"))

x <- x[order(x$a, x$b),]
isSorted(x, c("a", "b"))

x <- x[order(x$a,-x$b),]
isSorted(x, c("a", "b"), c(TRUE, FALSE))

}
