% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workbench_icon.r
\name{rawToAmigaIcon}
\alias{rawToAmigaIcon}
\title{Coerce raw data into an AmigaIcon class object}
\usage{
rawToAmigaIcon(x, palette = NULL)
}
\arguments{
\item{x}{A vector of \code{raw} data that needs to be converted into an S3
\code{\link{AmigaIcon}} class object.}

\item{palette}{Provide a palette (\code{vector} of colours) for the icon bitmap image.
When set to \code{NULL} (default) the standard Amiga Workbench palette will be used.}
}
\value{
Returns an \code{\link{AmigaIcon}} class object based on \code{x}.
}
\description{
\code{\link{AmigaIcon}} objects are comprehensive representations of binary Amiga
Workbench icon files (*.info). Use this function to convert \code{raw} data from
such a file to an \code{\link{AmigaIcon}} object.
}
\details{
Icons files (*.info) were used as a graphical representations of files and
directories on the Commodore Amiga. This function will convert the raw data from such files
into a more comprehensive names list (see \code{\link{AmigaIcon}}). Use
\code{\link[AmigaFFH]{as.raw}} to achieve the inverse.
}
\examples{
\dontrun{
## generate a simple AmigaIcon object:
icon <- simpleAmigaIcon()

## convert it into raw data:
icon.raw <- as.raw(icon)

## convert the raw data back into an icon:
icon.restored <- rawToAmigaIcon(icon.raw)
}
}
\seealso{
Other AmigaIcon.operations: 
\code{\link{AmigaIcon}},
\code{\link{read.AmigaIcon}()},
\code{\link{simpleAmigaIcon}()},
\code{\link{write.AmigaIcon}()}

Other raw.operations: 
\code{\link{as.AmigaBasic}()},
\code{\link{as.raw.AmigaBasic}()},
\code{\link{colourToAmigaRaw}()},
\code{\link{packBitmap}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasicShape}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToHWSprite}()},
\code{\link{rawToIFFChunk}()},
\code{\link{rawToSysConfig}()},
\code{\link{simpleAmigaIcon}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaIcon.operations}
\concept{raw.operations}
