% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{check.names.AmigaBasic}
\alias{check.names.AmigaBasic}
\title{Check Amiga Basic label/variable names for validity}
\usage{
check.names.AmigaBasic(x, ...)
}
\arguments{
\item{x}{A \code{vector} of \code{character} strings that need to be checked}

\item{...}{Currently ignored.}
}
\value{
A \code{data.frame} with \code{logical} values with the same number of rows as the length of \code{x}.
Columns in the data.frame corresponds with the criteria listed in the details.
\code{FALSE} for invalid names.
}
\description{
Check Amiga Basic label/variable names for validity
}
\details{
Names for variables and labels should adhere to the following rules in Amiga Basic:

\itemize{
  \item{Length of the names should be in the range of 1 up to 255 character}
  \item{Names cannot be \code{\link{AmigaBasic.reserved}} words}
  \item{Names should only contain alphanumeric characters or periods and
  should not contain special characters (i.e., reserved for type definition,
  such as dollar- or percentage sign)}
  \item{Names should not start with a numeric character}
}

This function tests names against each of these criteria.
}
\examples{
\dontrun{
## These are valid names in Amiga Basic:
check.names.AmigaBasic(c("Foo", "Bar"))

## Reserved words and repeated names are not allowed:

check.names.AmigaBasic(c("Print", "Foo", "Foo"))
}
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{AmigaBasic}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.character}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{write.AmigaBasic}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
