% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_setVarE}
\alias{SimParam_setVarE}
\title{Set simulation error variance}
\arguments{
\item{h2}{a vector of desired narrow-sense heritabilities}

\item{H2}{a vector of desired broad-sense heritabilities}

\item{varE}{a vector of error variances}
}
\description{
Defines a default value for error 
variances in the simulation.
}
\section{Usage}{
 SP$setVarE(h2 = NULL, H2 = NULL, varE = NULL)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)

}
