% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series.R
\name{COAST}
\alias{COAST}
\title{COding-variant Allelic Series Test}
\usage{
COAST(
  anno,
  geno,
  pheno,
  apply_int = TRUE,
  covar = NULL,
  include_orig_skato_all = FALSE,
  include_orig_skato_ptv = FALSE,
  is_pheno_binary = FALSE,
  min_mac = 0,
  ptv_anno = 3,
  pval_weights = NULL,
  return_omni_only = FALSE,
  score_test = FALSE,
  weights = c(1, 2, 3)
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with integer values in 1 through
the number of annotation categories L.}

\item{geno}{(n x snps) genotype matrix.}

\item{pheno}{(n x 1) phenotype vector.}

\item{apply_int}{Apply rank-based inverse normal transform to the phenotype?
Default: TRUE. Ignored if phenotype is binary.}

\item{covar}{(n x p) covariate matrix. Defaults to an (n x 1) intercept.}

\item{include_orig_skato_all}{Include the original version of SKAT-O applied
to all variants in the omnibus test? Default: FALSE.}

\item{include_orig_skato_ptv}{Include the original version of SKAT-O applied
to PTV variants only in the omnibus test? Default: FALSE.}

\item{is_pheno_binary}{Is the phenotype binary? Default: FALSE.}

\item{min_mac}{Minimum minor allele count for inclusion. Default: 0.}

\item{ptv_anno}{Annotation of the PTV category, only required if
include_orig_skato_ptv is set to TRUE.}

\item{pval_weights}{Optional vector of relative weights for combining the
component tests to perform the omnibus test. By default, 50\% of weight is
given to the 6 burden tests, and 50\% to the 1 SKAT test. If specified, the
weight vector should have length 7, and the length should be increased if
either \code{include_orig_skato_all} or \code{include_orig_skato_ptv} is active.}

\item{return_omni_only}{Return only the omnibus p-value? Default: FALSE.}

\item{score_test}{Use a score test for burden analysis? If FALSE, uses a
Wald test.}

\item{weights}{(L x 1) vector of annotation category weights. Note that the
number of annotation categories L is inferred from the length of \code{weights}.}
}
\value{
An object of class \code{COAST} with slots for effect sizes, variant
counts, and p-values.
}
\description{
Main allelic series test. Performs both Burden and SKAT type tests, then
combines the results to calculate an omnibus p-value.
}
\examples{
# Generate data.
data <- DGP(n = 1e3, snps = 1e2)

# Run the COding-variant Allelic Series Test.
results <- COAST(
  anno = data$anno,
  geno = data$geno,
  pheno = data$pheno,
  covar = data$covar
)
show(results)

}
