\name{gen.mixture}
\alias{gen.mixture}
\title{Generate mixture}
\description{
 Creates a candidate list of mixture variables.
}
\usage{
gen.mixture(levels,vars)
}
\arguments{
	\item{levels}{An integer greater than 1. The number of levels of the mixture variables.}
	\item{vars}{Either the number of variables, or a character vector of variable names.}
}

\details{
Similar in function to gen.factorial(), but for mixture variables such that the rows sum to unity.
For \code{levels=2}, the identity matrix is produced, so that each variable is either 0 or 1. For 
\code{levels=3}, rows are added to the identity containing two variables at 1/2 and the others at 0. etc.

In general, a mixture model of degree d will have the same number of terms as the candidate
list generated by \code{gen.mixture} for \code{levels=d+1}, and this will be optimal. 

}

\author{
	Bob Wheeler \email{bwheeler@echip.com}
	
	Please cite this program as follows:

Wheeler, R.E. (2004). gen.mixture. \emph{AlgDesign}. The R project for statistical computing \url{http://www.r-project.org/}
}
\keyword{design}

