% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_enhanceData.R
\name{pas_enhanceData}
\alias{pas_enhanceData}
\title{Enhance synoptic data from PurpleAir}
\usage{
pas_enhanceData(pas_raw = NULL, countryCodes = NULL, includePWFSL = TRUE)
}
\arguments{
\item{pas_raw}{Dataframe returned by \code{pas_downloadParseRawData()}.}

\item{countryCodes}{ISO country codes used to subset the data.}

\item{includePWFSL}{Logical specifying whether to calculate distances from 
PWFSL monitors.}
}
\value{
Enhanced Dataframe of synoptic PurpleAir data.
}
\description{
Enhance raw synoptic data from PurpleAir to create a generally 
useful dataframe.

Steps include:

1) Replace variable with more consistent, more human readable names.

2) Add spatial metadata for each sensor including:
\itemize{
  \item{timezone -- olson timezone}
  \item{countryCode -- ISO 3166-1 alpha-2}
  \item{stateCode -- ISO 3166-2 alpha-2}
  \item{airDistrict -- CARB air districts}
}

3) Convert data types from character to \code{POSIXct} and \code{numeric}.

4) Add distance and monitorID for the two closest PWFSL monitors

5) Add additional metadata items:
\itemize{
\item{sensorManufacturer = "Purple Air"}
\item{targetPollutant = "PM"}
\item{technologyType = "consumer-grade"}
\item{communityRegion -- (where known)}
}

Filtering by country can speed up the process of enhancement and may be
performed by providing a vector ISO country codes to the \code{countryCodes} 
argument. By default, no subsetting is performed.

Setting \code{outsideOnly = TRUE} will return only those records marked as 
'outside'.
}
\note{
For data obtained on July 28, 2018 this will result in removal of all 
'B' channels, even those whose parent 'A' channel is marked as 'outside'. 
This is useful if you want a quick, synoptic view of the network, e.g. for a 
map.
}
\examples{
\donttest{
library(AirSensor)

initializeMazamaSpatialUtils()

pas <- pas_enhanceData(example_pas_raw, 'US')

setdiff(names(pas), names(example_pas_raw))
setdiff(names(example_pas_raw), names(pas))

if ( interactive() ) {
  View(pas[1:100,])
}
}
}
\seealso{
\link{pas_downloadParseRawData}
}
