% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AirMonitor.R
\docType{data}
\name{US_AQI}
\alias{US_AQI}
\title{US EPA AQI Index levels, names, colors and action text}
\format{
A list with named elements
}
\usage{
US_AQI
}
\description{
Official, US EPA AQI levels, names, colors and action text are provided in a
list for easy coloring and labeling.
}
\details{
AQI breaks and associated names and colors
}
\note{
The low end of each break category is used as the breakpoint.
}
\section{Breaks}{


Breakpoints are given in units reported for each parameter and include:
\itemize{
\item{\code{breaks_AQI}}
\item{\code{breaks_CO}}
\item{\code{breaks_NO2}}
\item{\code{breaks_OZONE_1hr}}
\item{\code{breaks_OZONE_8hr}}
\item{\code{breaks_PM2.5}}
\item{\code{breaks_PM10}}
}
}

\section{Colors}{


Several different color palettes are provided:
\itemize{
\item{\code{colors_EPA} -- official EPA AQI colors}
\item{\code{colors_subdued} -- subdued colors fo use with leaflet maps}
\item{\code{colors_deuteranopia} -- color vision impaired colors}
}
}

\section{Names}{


Names of AQI categories are provided in several languages identified by the
ISO 639-2 alpha-3 code:
\itemize{
\item{\code{names_eng}}
\item{\code{names_spa}}
}
}

\section{Actions}{


Text for "actions to protect yourself" are provided for each
category in several languages identified by the
ISO 639-2 alpha-3 code:
\itemize{
\item{\code{actions_eng}}
\item{\code{actions_spa}}
}

Currently supported languages include English (eng) and Spanish (spa).

AQI breaks are defined at
\url{https://www.airnow.gov/sites/default/files/2020-05/aqi-technical-assistance-document-sept2018.pdf}
and are given in units appropriate for each pollutant.

AQI colors are defined at \url{https://docs.airnowapi.org/aq101}
}

\examples{
print(US_AQI$breaks_AQI)
print(US_AQI$colors_EPA)
print(US_AQI$names_eng)
print(US_AQI$names_spa)
}
\keyword{datasets}
