% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_function.R
\name{compute_event_durations}
\alias{compute_event_durations}
\title{Computation of event durations.}
\usage{
compute_event_durations(disp.data = NULL, presc.data = NULL,
  hosp.data = NULL, ID.colname = NA, presc.date.colname = NA,
  disp.date.colname = NA, date.format = "\%d.\%m.\%Y",
  medication.class.colnames = NA, total.dose.colname = NA,
  presc.daily.dose.colname = NA, presc.duration.colname = NA,
  visit.colname = NA, force.init.presc = FALSE,
  force.presc.renew = FALSE, split.on.dosage.change = TRUE,
  trt.interruption = c("continue", "discard", "carryover")[1],
  suppress.warnings = FALSE, return.data.table = FALSE, ...)
}
\arguments{
\item{disp.data}{A \emph{\code{data.frame}} or \emph{\code{data.table}} containing
the dispensing events. Must contain, at a minimum, the patient unique ID, one
medication identifier, the dispensing date, and total dispensed dose, and might
also contain additional columns to identify and group medications (the actual
column names are defined in the \emph{\code{medication.class.colnames}} parameter).}

\item{presc.data}{A \emph{\code{data.frame}} containing the prescribing events.
Must contain, at a minimum, the same unique patient ID and medication identifier(s)
as the dispensing data, the prescription date, the daily prescribed dose, and the
prescription duration. Optionally, it might also contain a visit number.}

\item{hosp.data}{Optional, \emph{\code{NULL}} or a \emph{\code{data.frame}}
containing the hospitalization periods (or other situations where patients may not
use their own supply, e.g. during incarcerations). Must contain the same unique
patient ID as dispensing and prescription data, and the start and end dates of the
hospitalizations with the exact column names \emph{\code{DATE.IN}} and
\emph{\code{DATE.OUT}}.}

\item{ID.colname}{A \emph{string}, the name of the column in \code{disp.data},
\code{presc.data}, and \code{hosp.data} containing the unique patient ID, or
\code{NA} if not defined.}

\item{presc.date.colname}{A \emph{string}, the name of the column in
\code{presc.data} containing the prescription date (in the format given in
the \code{date.format} parameter), or \code{NA} if not defined.}

\item{disp.date.colname}{A \emph{string}, the name of the column in
\code{disp.data} containing the dispensing date (in the format given in
the \code{date.format} parameter), or \code{NA} if not defined.}

\item{date.format}{A \emph{string} giving the format of the dates used in
the \code{data} and the other parameters; see the \code{format} parameters
of the \code{\link[base]{as.Date}} function for details (NB, this concerns
only the dates given as strings and not as \code{Date} objects).}

\item{medication.class.colnames}{A \emph{\code{Vector}} of \emph{strings}, the
name(s) of the column(s) in \code{disp.data} and \code{presc.data} containing
the classes/types/groups of medication, or \code{NA} if not defined.}

\item{total.dose.colname}{A \emph{string}, the name of the column in
\code{disp.data} containing the total dispensed dose as \code{numeric} (e.g.
\code{500} for 10 tablets of 50 mg), or \code{NA} if not defined.}

\item{presc.daily.dose.colname}{A \emph{string}, the name of the column in
\code{presc.data} containing the daily prescribed dose as \code{numeric} (e.g.
\code{50} for 50 mg once per day, or 25 for 50 mg once ever 2 days), or \code{NA}
if not defined.}

\item{presc.duration.colname}{A \emph{string}, the name of the column in
\code{presc.data} containing the duration of the prescription as \code{numeric}
or \code{NA} if duration is unknown.}

\item{visit.colname}{A \emph{string}, the name of the column in
\code{presc.data} containing the number of the visit, or \code{NA} if not defined.}

\item{force.init.presc}{\emph{Logical}. If \code{TRUE} advance the date of the
first prescription event to the date of the first dispensing event, if the first
prescription event is after the first dispensing event for a specific medication.
Only if the first prescription event is not limited in duration (as indicated in
the \code{presc.duration.colname}).}

\item{force.presc.renew}{\emph{Logical} or \emph{string}. If \code{TRUE} require
a new prescription for all medications for every prescription event (visit),
otherwise prescriptions end on the first visit without renewal. If \emph{string},
the name of the column containing the \code{Logical} for each medication class
separatly.}

\item{split.on.dosage.change}{\emph{Logical} or \emph{string}. If \code{TRUE}
split the dispensing event on days with dosage change and create a new event with
the new dosage for the remaining supply. If \emph{string}, the name of the column
containing the \code{Logical} for each medication class separatly. Important if
carryover should be considered later on.}

\item{trt.interruption}{can be either \emph{continue}, \emph{discard}, or
\emph{carryover}, and indicates how to handle supplies affected by treatment
interruptions or hospitalizations. With \emph{continue}, interruptions have
no effect on durations and dispensing start dates. With \emph{discard}, supplies
are truncated at the beginning of an interruption or hospitalization and the
remaining supply is discarded. With \emph{carryover}, supplies are truncated
at the beginning of an interruption or hospitalization and a new dispensing
start event with the remaining supply is created after the end of the interruption
or hospitalization.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any warnings.}

\item{return.data.table}{\emph{Logical}, if \code{TRUE} return a
\code{data.table} object, otherwise a \code{data.frame}.}

\item{...}{other possible parameters.}
}
\value{
A \code{data.frame} or \code{data.table} with the following columns:
\itemize{
 \item \code{ID.colname} the unique patient ID, as given by the \code{ID.colname}
 parameter.
 \item \code{medication.class.colnames} the column(s) with classes/types/groups
 of medication, as given by the \code{medication.class.colnames} parameter.
 \item \code{total.dose.colname} the total dispensed dose, as given by the
 \code{total.dose.colname} parameter.
 \item \code{disp.date.colname} the date of the dispensing event, as given by
 the \code{disp.date.colnema} parameter.
 \item \code{DISP.START} the start date of the dispensing event, either the
 same as in \code{disp.date.colnema} or a later date in case of dosage changes
 or treatment interruptions/hospitalizations.
 \item \code{presc.daily.dose.colname} the prescribed daily dose, as given by
 the \code{presc.daily.dose.colname} parameter.
 \item \code{DURATION} the calculated duration of the supply, based on the total
 dispensed dose and the prescribed daily dose, starting from the \code{DISP.START}
 date.
 \item \code{START.PRESC} the start date of the prescription episode.
 \item \code{END.PRESC} the end date of the prescription episode.
 \item \code{HOSP.DURATION} the number of days during the current supply period
 affected by hospitalizations.
 \item \code{tot.presc.interruptions} the total number of prescription interruptions
 per patient for a specific medication.
 \item \code{tot.dosage.changes} the total number of dosage changes per patient
 for a specific medication.
 }
 @examples
   event_durations <- compute_event_durations(disp.data = durcomp.dispensing,
                                              presc.data = durcomp.prescribing,
                                              hosp.data = durcomp.hospitalisation,
                                              ID.colname = "ID",
                                              presc.date.colname = "DATE.PRESC",
                                              disp.date.colname = "DATE.DISP",
                                              date.format = "%Y-%m-%d",
                                              medication.class.colnames = c("ATC.CODE", "UNIT", "FORM"),
                                              total.dose.colname = "TOTAL.DOSE",
                                              presc.daily.dose.colname = "DAILY.DOSE",
                                              presc.duration.colname = "PRESC.DURATION",
                                              visit.colname = "VISIT",
                                              force.init.presc = TRUE,
                                              force.presc.renew = TRUE,
                                              split.on.dosage.change = TRUE,
                                              trt.interruption = "continue",
                                              suppress.warnings = FALSE,
                                              return.data.table = TRUE)
}
\description{
Computes event durations based on dispensing, prescription, and hospitalization
data and returns a \code{data.frame} which can be used with the CMA constructors
in \code{AdhereR}.
}
\details{
Computation of CMAs requires a supply duration for medications dispensed to
patients. If medications are not supplied for fixed durations but as a quantity
that may last for various durations based on the prescribed dose, the supply
duration has to be calculated based on dispensed and prescribed doses. Treatments
may be interrupted and resumed at later times, for which existing supplies may
or may not be taken into account. Patients may be hospitalized or incarcerated,
and may not use their own supplies during these periods. This function calculates
supply durations, taking into account the aforementioned situations and providing
various parameters for flexible adjustments.
}
