\name{hchen}
\alias{hchen}
\title{Chen hazard rate function}
\description{Computes the hazard rate function of the Chen distribution}
\usage{
hchen(x, beta = 1, lambda = 1)
}
\arguments{
  \item{x}{scale or vector of positive values at which the hazard rate function needs to be computed}
  \item{beta}{the value of beta parameter, must be positive}
  \item{lambda}{the value of lambda parameter, must be positive}
}
\value{An object of the same length as \code{x}, giving the hazard rate function values computed at \code{x}}
\references{S. Nadarajah, S. A. A. Bakar, Tabulations of survival models for actuarial use, submitted}
\author{Saralees Nadarajah}
\note{If incorrect values are input for \code{x} or the model parameters then NaNs will be returned as the output.}

\examples{x=runif(10,min=0,max=1)
y=hchen(x)

## The function is currently defined as
function (x, beta = 1, lambda = 1) 
{
    ret = ifelse(x <= 0 | beta <= 0 | lambda <= 0, NaN, beta * 
        lambda * x^(beta - 1) * exp(x^beta))
    return(ret)
  }
}
\keyword{Chen distribution}
