% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoscape.r
\name{prepareCytoscape}
\alias{prepareCytoscape}
\title{Prepare files for building an enrichment map network visualization in Cytoscape}
\usage{
prepareCytoscape(terms, gmt, cytoscape.file.tag, col.significance)
}
\arguments{
\item{terms}{A data.table object with the columns 'term.id', 'term.name', 'adjusted.p.val'.}

\item{gmt}{An abridged GMT object containing only the pathways that were
found to be significant in the ActivePathways analysis.}

\item{cytoscape.file.tag}{The user-defined file prefix and/or directory defining the location of the files.}

\item{col.significance}{A data.table object with a column 'term.id' and a column
for each type of omics evidence indicating whether a term was also found to be signficiant or not
when considering only the genes and p-values in the corresponding column of the \code{scores} matrix. If term was not found, NA's are shown in columns, otherwise the relevant lists of genes are shown.}
}
\value{
None
}
\description{
This function writes four text files that are used to build an network using
Cytoscape and the EnrichmentMap app. The files are prefixed with \code{cytoscape.file.tag}. 
  The four files written are:
  \describe{
    \item{pathways.txt}{A list of significant terms and the
    associated p-value. Only terms with \code{adjusted.p.val <= significant} are
    written to this file}
    \item{subgroups.txt}{A matrix indicating whether the significant
    pathways are found to be significant when considering only one column (i.e., type of omics evidence) from
    \code{scores}. A 1 indicates that that term is significant using only that
    column to test for enrichment analysis}
    \item{pathways.gmt}{A shortened version of the supplied GMT
    file, containing only the terms in pathways.txt.}
    \item{legend.pdf}{A legend with colours matching contributions
    from columns in \code{scores}}
  }
}
