% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/night.shade.r
\name{local.night.shade}
\alias{local.night.shade}
\title{Generates local night time periods}
\usage{
local.night.shade(x, shadow.start = "20:00:00", shadow.end = "06:00:00",
  localTZ, tz = "UTC", ...)
}
\arguments{
\item{x}{a dataframe}

\item{shadow.start}{starting time of the home night, 22:00:00 by defaults}

\item{shadow.end}{ending time of the home night, 08:00:00 by defaults}

\item{localTZ}{a dataframe containing the local time zone by participant during the days worked.}

\item{tz}{the time zone}

\item{...}{Optional parameters}
}
\value{
a dataframe
}
\description{
This function is used by the Darwent plot
}
\examples{
library("dplyr")
library("lubridate")
data(act)
# Selecting the date/time arrival to Amsterdam for subject_ID 1
start_date <- act[act$subject_ID==1 & act$interval_type == "FLIGHT" &
act$comments == "SIN-AMS",]$datime_end
sel <- act[act$datime_start >= start_date & act$datime_end <= start_date + lubridate::days(10),]
localTZ <- data.frame(subject_ID = "1",
                      TZ = "Europe/Amsterdam", stringsAsFactors = FALSE)
local.night.shade(sel, shadow.start = "20:00:00",
                  shadow.end = "06:00:00", localTZ = localTZ)


}
