% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_down.R
\name{step1_down}
\alias{step1_down}
\title{Step1 Down Model}
\usage{
step1_down(
  data,
  y,
  .time,
  K = NULL,
  C = NULL,
  validation = NULL,
  draw = 10000,
  parms = NULL,
  temp_pred_C = NULL,
  max_time_pred = NULL,
  confidence_interval = 0.95,
  by = 101,
  reparameterisation = FALSE,
  zero_order = FALSE,
  ...
)
}
\arguments{
\item{data}{Dataframe containing accelerated stability data (required).}

\item{y}{Name of decreasing variable (e.g. concentration) contained within data
(required).}

\item{.time}{Time variable contained within data (required).}

\item{K}{Kelvin variable (numeric or column name) (optional).}

\item{C}{Celsius variable (numeric or column name) (optional).}

\item{validation}{Validation dummy variable, the column must contain only
1s and 0s, 1 for validation data and 0 for fit data. (column name) (optional).}

\item{draw}{Number of simulations used to estimate confidence intervals.
When set to NULL the calculus method is used, however this is not recommended.}

\item{parms}{Starting values for the parameters as a list - k1, k2, k3, and c0.}

\item{temp_pred_C}{Integer or numeric value to predict the response for a
given temperature (in Celsius).}

\item{max_time_pred}{Maximum time to predict the response variable.}

\item{confidence_interval}{Confidence level for the confidence and prediction intervals
around the predictions (default 0.95).}

\item{by}{Number of points (on the time scale) to smooth the statistical
intervals around the predictions.}

\item{reparameterisation}{Use alternative parameterisation of the one-step
model which aims to reduce correlation between k1 and k2.}

\item{zero_order}{Set kinetic order, k3, to zero (straight lines).}

\item{...}{Further arguments to passed to minpack.lm.}
}
\value{
An SB class object, a list including the following elements:
\itemize{
\item \emph{fit} - The non-linear fit.
\item \emph{data} - The data set.
\item \emph{prediction} - A data frame containing the predictions with the confidence and prediction intervals.
\item \emph{user_parameters} - List of users input parameters which is utilised by other
functions in the package.
\item \emph{sample_coefficients} - A matrix containing the coefficients sampled during bootstrapping.
}
}
\description{
Fit the one-step Šesták–Berggren kinetic model.
}
\details{
Fit the one-step Šesták–Berggren kinetic (non-linear) model using
accelerated stability data that has been stored in an R data frame. Additionally,
predictions of the mean at each tested temperature are returned, including associated
confidence and prediction intervals, which can be subsequently visualised with
step1_plot_pred(), step1_plot_CI(), step1_plot_PI() and step1_plot_T(). Kinetic
parameters (k1, k2 and, if used, k3) are retained in the model even if one or more of
these parameters turn out to be non-significant. Further arguments relating to
model fitting, such as setting lower bounds for one or more model parameters,
may be passed.
}
\examples{
#load antigenicity and potency data.
data(antigenicity)
data(potency)

#Basic use of the step1_down function with C column defined.
fit1 <- step1_down(data = antigenicity, y = "conc", .time = "time", C = "Celsius", draw = 5000)

#Basic use of the step1_down function with K column defined & Validation data segmented out.
fit2 <- step1_down(data = antigenicity, y = "conc", .time = "time", K = "K",
validation = "validA", draw = 5000)

#When zero_order = FALSE, the output suggests using zero_order = TRUE for Potency dataset.
fit3 <- step1_down(data = potency, y = "Potency", .time = "Time",C = "Celsius",
  reparameterisation = FALSE, zero_order = TRUE, draw = 5000)

#reparameterisation is TRUE.
fit4 <- step1_down(data = antigenicity, y = "conc", .time = "time",C = "Celsius",
  reparameterisation = TRUE, draw = 5000)

#Use a custom lower bound for k1 (default is 0).
fit5 <- step1_down(data = potency, y = "Potency", .time = "Time",C = "Celsius",
  reparameterisation = TRUE, zero_order = TRUE, draw = 5000, lower = c(-Inf, 0, 0))

}
