% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSISTDesigns.R
\docType{class}
\name{DEFUSE3Design}
\alias{DEFUSE3Design}
\title{The DEFUSE3 design}
\format{An \code{\link{R6Class}} generator object}
\usage{
DEFUSE3Design
}
\description{
\code{DEFUSE3Design} is a slight variant of the the adaptive
clinical trial design of Lai, Lavori and Liao. Simulation is used to compute
the expected maximum sample size and the boundary for early futility is adjusted to
account as well.
}
\section{Methods}{


\describe{
  \item{\code{new(designParameters, trialParameters, generateData,
        numberOfSimulations, rngSeed)}}{Create
        a new instance object using the parameters specified. Default number of simulations is 5000
        for re-estimating effect size, 54321 for seed. Also the parameter \code{showProgress} is by default
       \code{TRUE}.}
  \item{\code{getDesignParameters}, \code{getTrialParameters},
        \code{getBoundaries}}{Accessor methods for (obvious) object slots}
  \item{\code{print()}}{Print the object in a human readable form}
  \item{\code{adjustCriticalValues(numberOfSimulations, rngSeed, showProgress)}}{Adjust the critical values
        by performing simulations using the parameters provided}
  \item{\code{computeCriticalValues()}}{Compute the critical boundary value \eqn{c_\alpha}}
  \item{\code{explore(numberOfSimulations, rngSeed,
              trueParameters, showProgress)}}{Explore the
        design using the specified number of simulations (default 5000) and random number seed (default 12345).
        The argument \code{trueParameters} is by default the same
        as \code{designParameters} as would be the case for a Type I error calculation. If changed, would yield power.
        Show progress if so desired (default \code{TRUE}). Returns a data frame of results}
  \item{\code{analyze(trialHistory)}}{Analyze
        the design given the \code{trialHistory} which is the result of a call to \code{explore} to
        simulate the design. Return a list of summary quantities}
  \item{\code{summary(analysis)}}{Print the operating characteristics of the design, using the analysis
        result from the \code{analyze} call}
}
}
\examples{
trialParameters <- list(N = c(200, 340, 476), type1Error = 0.025,
                        eps = 1/2, type2Error = 0.1)
designParameters <- list(
   nul0 = list(prevalence = rep(1/6, 6), mean = matrix(0, 2, 6),
               sd = matrix(1, 2, 6)),
   alt1 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.4, 0.3, 0, 0, 0)),
               sd = matrix(1, 2, 6)),
   alt2 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.5, 0, 0, 0, 0)),
               sd = matrix(1,2, 6)),
   alt3 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6), rep(0.36, 6)),
               sd = matrix(1,2, 6)),
   alt4 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6), rep(0.30, 6)),
               sd = matrix(1,2, 6)),
   alt5 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.4, 0.3, 0.2, 0, 0, 0)),
               sd = matrix(1,2, 6)),
   alt6 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.5, 0.3, 0.3, 0.1, 0.1)),
               sd = matrix(1,2, 6)))

\dontrun{
## A realistic design uses 5000 simulations or more!
defuse3 <- DEFUSE3Design$new(trialParameters = trialParameters,
                             numberOfSimulations = 25,
                             designParameters = designParameters$nul0,
                             showProgress = FALSE)
print(defuse3)
result <- defuse3$explore(showProgress = interactive())
analysis <- defuse3$analyze(result)
print(defuse3$summary(analysis))
}
## For full examples, try:
## browseURL(system.file("full_doc/defuse3.html", package="ASSISTant"))

}
\references{
Adaptive design of confirmatory trials: Advances and challenges
by Tze Leung Lai and Philip W. Lavori and Ka Wai Tsang. Contemporary Clinical Trials,
Vol. 45, Part A, pp 93-102 (2015). \url{http://www.sciencedirect.com/science/article/pii/S1551714415300239}.
}
\seealso{
\code{ASSISTDesign} which is a superclass of this object
}
\keyword{datasets}

