% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARpMMEC.sim.R
\name{ARpMMEC.sim}
\alias{ARpMMEC.sim}
\title{Generating Censored Autoregressive Dataset with Mixed Effects.}
\usage{
ARpMMEC.sim(
  m,
  x = NULL,
  z = NULL,
  tt = NULL,
  nj,
  beta,
  sigmae,
  D,
  phi,
  p.cens = 0,
  cens.type = "left"
)
}
\arguments{
\item{m}{Number of individuals}

\item{x}{Design matrix of the fixed effects of order \code{n x s}, corresponding to vector of fixed effects.}

\item{z}{Design matrix of the random effects of order\code{n x b}, corresponding to vector of random effects.}

\item{tt}{Vector \code{1 x n} with the time the measurements were made, where \code{n} is the total number of measurements for all individuals.}

\item{nj}{Vector \code{1 x m} with the number of observations for each subject,  where \code{m} is the total number of individuals.}

\item{beta}{Vector of values fixed effects.}

\item{sigmae}{It's the value for sigma.}

\item{D}{Covariance Matrix for the random effects.}

\item{phi}{Vector of length \code{Arp}, of values for autoregressive parameters.}

\item{p.cens}{Censoring level for the process. Default is \code{0}}

\item{cens.type}{\code{left} for left censoring, \code{right} for right censoring and \code{interval} for intervalar censoring. Default is \code{left}}
}
\value{
returns list:
\item{cc}{Vector of censoring indicators.}
\item{y_cc}{Vector of responses censoring.}
}
\description{
This function simulates a censored response variable with autoregressive errors of order \code{p}, with mixed effect and a established censoring rate. This function returns the censoring vector and censored response vector.
}
\examples{
\dontrun{
 p.cens   = 0.1
 m           = 50
 D = matrix(c(0.049,0.001,0.001,0.002),2,2)
 sigma2 = 0.30
 phi    = c(0.48,-0.2)
 beta   = c(1,2,1)
 nj=rep(6,m) 
 tt=rep(seq(1:6),m)
 x<-matrix(runif(sum(nj)*length(beta),-1,1),sum(nj),length(beta))
 z<-matrix(runif(sum(nj)*dim(D)[1],-1,1),sum(nj),dim(D)[1])
 data=ARpMMEC.sim(m,x,z,tt,nj,beta,sigma2,D,phi,p.cens)
 y<-data$y_cc
 cc<-data$cc
}
}
