% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{check_meta}
\alias{check_meta}
\title{Check output of \code{clean_metadata()}}
\usage{
check_meta(meta, date = FALSE)
}
\arguments{
\item{meta}{Data frame. Recording metadata. Output of \code{clean_metadata()}.}

\item{date}{Logical. Whether to summarize output by date (as well as
\code{site_id} and \code{aru_id}. Default \code{FALSE}.}
}
\value{
A data frame summarizing the metadata by site_id, aru_type, aru_id,
and (optionally) by date. Presents the number of files, directories, and days
worth of recordings, as well as the minimum and maximum recording times.
}
\description{
Cleaning metadata can take a series of tries. This function helps summarize
and explore the metadata for possible patterns which may help find problems.
}
\examples{
m <- clean_metadata(project_files = example_files)

check_meta(m)
check_meta(m, date = TRUE)

}
