% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PIRapp.R
\name{PIR_loglik}
\alias{PIR_loglik}
\title{Calculate log-likelihood}
\usage{
PIR_loglik(phi, zeta, U, c, d)
}
\arguments{
\item{phi}{value for prevalence}

\item{zeta}{value for incidence}

\item{U}{a vector containing interval-level PIR data}

\item{c}{the length of the active interval}

\item{d}{the length of the recording interval}
}
\value{
The value of the log-likelihood
}
\description{
Calculates the log-likelihood of within-session PIR data
}
\details{
\code{phi} must be a value between 0 and 1, inclusive of 0 and 1. \
code{zeta} must be a value greater than 0.

The vector \code{U} should only contain values of 1 or 0.

\code{c} must be some positive value in whatever time units the observation took place in (typically seconds). \code{d} must be some non-negative value - a
\code{d} of zero represents a PIR observation where no time was set aside for recording.
}
\author{
Daniel Swan <dswan@utexas.edu>
}

