% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Lombardia_geospatial.R
\name{get_Lombardia_geospatial}
\alias{get_Lombardia_geospatial}
\title{Download geospatial data of Lombardy from Eurostat}
\usage{
get_Lombardia_geospatial(NUTS_level = "LAU")
}
\arguments{
\item{NUTS_level}{NUTS level required: use "NUTS2" for regional geometries, "NUTS3" for provincial geometries,
or "LAU" for municipal geometries. Default NUTS_level = "LAU".}
}
\value{
A data frame of class 'data.frame', "sf" and 'ARPALdf'.
}
\description{
'get_Lombardia_geospatial' returns the polygonal (shape file) object containing the geometries
of Lombardy. Shapefile are available at different NUTS levels: 'LAU' for the shapefile of municipalities of
Lombardy, 'NUTS3' for the shapefile of provinces of Lombardy and 'NUTS2' for the shapefile of Lombardy.
}
\examples{
\donttest{
shape <- get_Lombardia_geospatial(NUTS_level = "LAU")
}

}
