% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ARPA_Lombardia_AQ_municipal_data.R
\name{get_ARPA_Lombardia_AQ_municipal_data}
\alias{get_ARPA_Lombardia_AQ_municipal_data}
\title{Download air quality data at manucipal from ARPA Lombardia website}
\usage{
get_ARPA_Lombardia_AQ_municipal_data(
  ID_station = NULL,
  Year = 2022,
  Frequency = "daily",
  Var_vec = NULL,
  Fns_vec = NULL,
  by_sensor = F,
  parallel = T,
  verbose = T
)
}
\arguments{
\item{ID_station}{Numeric value. ID of the station to consider. Using ID_station = NULL, all the available
stations are selected. Default is ID_station = NULL.}

\item{Year}{Numeric vector. Year(s) of interest. Default is Year = 2022 Specifying more than one year the
code works in parallel computing (half of the available cores) using parLapply() function.}

\item{Frequency}{Temporal aggregation frequency. It can be "daily", "weekly", "monthly" or "yearly".
Default is Frequency = "daily".}

\item{Var_vec}{Character vector of variables to aggregate. If NULL (default) all the variables are averaged.}

\item{Fns_vec}{Character vector of aggregation function to apply to the selected variables.
Available functions are mean, median, min, max, sum, qPP (PP-th percentile), sd, var,
vc (variability coefficient), skew (skewness) and kurt (kurtosis).}

\item{by_sensor}{Boolean. If 'by_sensor=1', the function returns the observed concentrations by sensor code, while
if 'by_sensor=0' (default) it returns the observed concentrations by station.}

\item{parallel}{Logic value (T or F). If 'parallel=T' (default), data downloading is performed using parallel computing
(socketing), while if 'parallel=F' (default) the download is performed serially. 'parallel=T' works only when
'Year' is a vector with multiple values, i.e. for a single year the serial computing is performed.}

\item{verbose}{Logic value (T or F). Toggle warnings and messages. If 'verbose=T' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose=F' any message about
the progression is suppressed.}
}
\value{
A data frame of class 'data.frame' and 'ARPALdf'. The object is fully compatible with Tidyverse.
The column 'NameStation' identifies the name of each municipality. The column 'IDStation' is an ID code
(assigned from ARPA) uniquely identifying each municipality.
}
\description{
'get_ARPA_Lombardia_AQ_municipal_data' returns the air quality levels at municipal level estimated by
ARPA Lombardia using a physico-chemical model which simulates air quality based on weather and geo-physical
variables. For each municipality of Lombardy, ARPA estimates the average (NO2_mean) and maximum daily (NO2_max_day)
level of NO2, the daily maximum (Ozone_max_day) and the 8-hours moving window maximum (Ozone_max_8h) of Ozone
and the average levels of PM10 (PM10_mean) and PM2.5 (PM2.5_mean).
Data are available from 2011 and are updated up to the current date.
For more information about the municipal data visit the section 'Stime comunali dell'aria' at the webpage:
https://www.dati.lombardia.it/stories/s/auv9-c2sj
}
\details{
More detailed description.
}
\examples{
\donttest{
## Download daily concentrations at municipal levels observed in 2020
## for all the cities in Lombardy
get_ARPA_Lombardia_AQ_municipal_data(ID_station=NULL,Year=2020,
     Frequency="daily")
## Download monthly concentrations of NO2 (average and maximum) observed in 2021
## at city number 100451.
get_ARPA_Lombardia_AQ_municipal_data(ID_station=100451,Year=2021,
      Frequency="monthly",Var_vec=c("NO2_mean","NO2_mean"),Fns_vec=c("mean","max"))
## Download daily concentrations observed in 2021 at city number 100451.
## Data are reported by sensor.
get_ARPA_Lombardia_AQ_municipal_data(ID_station=100451,Year=2021,by_sensor = 1)
}

}
