% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ARPA_Lombardia_AQ_data.R
\name{get_ARPA_Lombardia_AQ_data}
\alias{get_ARPA_Lombardia_AQ_data}
\title{Download air quality data from ARPA Lombardia website}
\usage{
get_ARPA_Lombardia_AQ_data(
  ID_station = NULL,
  Year = 2019,
  Frequency = "hourly",
  Var_vec = NULL,
  Fns_vec = NULL,
  by_sensor = 0,
  verbose = T
)
}
\arguments{
\item{ID_station}{Numeric value. ID of the station to consider. Using ID_station = NULL, all the available
stations are selected. Default is ID_station = NULL.}

\item{Year}{Numeric vector. Year(s) of interest. Default is Year = 2019. Specifying more than one year the
code works in parallel computing (half of the available cores) using parLapply() function.}

\item{Frequency}{Temporal aggregation frequency. It can be "hourly", "daily", "weekly", "monthly" or "yearly".
Default is Frequency = "hourly"}

\item{Var_vec}{Character vector of variables to aggregate. If NULL (default) all the variables are averaged,
expect for 'Temperature' and 'Snow_height' which are summed.}

\item{Fns_vec}{Character vector of aggregation function to apply to the selected variables. Available functions
are mean, median, min, max, sum and qPP (for the PP-th percentile).}

\item{by_sensor}{Logic value (0 or 1). If 'by_sensor=1', the function returns the observed concentrations
by sensor code, while if 'by_sensor=0' (default) it returns the observed concentrations by station.}

\item{verbose}{Logic value (T or F). Toggle warnings and messages. If 'verbose=T' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose=F' any message about
the progression is suppressed.}
}
\value{
A data frame of class 'data.frame' and 'ARPALdf'. The object is fully compatible with Tidyverse.
}
\description{
'get_ARPA_Lombardia_AQ_data' returns observed air quality measurements collected by
ARPA Lombardia ground detection system for Lombardy region in Northern Italy.
Available airborne pollutant concentrations are: NO2, NOx, PM10, PM2.5, Ozone, Arsenic, Benzene,
Benzo-a-pirene, Ammonia, Sulfur Dioxide, Black Carbon, CO, Nikel, Cadmium and Lead.
Data are available from 2011 and are updated up to the current date.
For more information about the municipal data visit the section 'Monitoraggio aria' at the webpage:
https://www.dati.lombardia.it/stories/s/auv9-c2sj
}
\examples{
\donttest{
## Download hourly air quality data for 2020 at station 501 .
get_ARPA_Lombardia_AQ_data(ID_station=501,Year=2020,Frequency="hourly",by_sensor = 0)
## Download monthly data for NOx and NO2 observed during 2020 for all the stations
## active on the network. For NOx is computed the 25th percentile, while for NO2 is
## computed the maximum concentration observed.
get_ARPA_Lombardia_AQ_data(ID_station=NULL,Year=2020,Frequency="monthly",
   Var_vec=c("NOx","NO2"),Fns_vec=c("q25","max"),by_sensor = 0)
## Download hourly air quality data for 2020 at station 501.
## Data are reported by sensor.
get_ARPA_Lombardia_AQ_data(ID_station=501,Year=2020,by_sensor = 1)
}

}
