% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_smoothEffects.R
\name{plot_1Dsmooth}
\alias{plot_1Dsmooth}
\title{Plot 1D smooth effects for \code{\link[mgcv]{gam}} models}
\usage{
plot_1Dsmooth(model, plot_ci = TRUE, select, alpha = 0.05, ylim = NULL)
}
\arguments{
\item{model}{GAM model fitted with \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{plot_ci}{If \code{TRUE} CIs are plotted. Only used if \code{plot_type = 1}.}

\item{select}{Index of smooth term to be plotted.}

\item{alpha}{\code{(1-alpha)} CIs are calculated. The default 0.05 leads to
95\% CIs.}

\item{ylim}{Optional limits of the y-axis.}
}
\value{
ggplot object
}
\description{
Plots 1D smooth effects for a GAM model fitted with \code{\link[mgcv]{gam}}
or \code{\link[mgcv]{bam}}.
}
\details{
If the model was estimated with a log or logit link, the function
automatically performs an exponential transformation of the effect.
}
\examples{
library(APCtools)
library(mgcv)

data(travel)
model <- gam(mainTrip_distance ~ te(age, period) + residence_region +
             household_size + s(household_income), data = travel)

plot_1Dsmooth(model, select = 2)

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
