% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_modelSummary.R
\name{create_modelSummary}
\alias{create_modelSummary}
\title{Create model summary tables for multiple estimated GAM models}
\usage{
create_modelSummary(model_list, digits = 2, ...)
}
\arguments{
\item{model_list}{list of APC models}

\item{digits}{number of displayed digits}

\item{...}{additional arguments to \code{\link[knitr]{kable}}}
}
\value{
List of tables created with \code{\link[knitr]{kable}}.
}
\description{
Create publication-ready summary tables of all linear and nonlinear effects
for models fitted with \code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.
The output format of the tables can be adjusted by passing arguments to
\code{\link[knitr]{kable}} via the \code{...} argument.
}
\details{
If the model was estimated with a log or logit link, the function
automatically performs an exponential transformation of the effects.

The table for linear coefficients includes the estimated coefficient
(\code{coef}), the corresponding standard error (\code{se}), lower and upper
limits of 95\% confidence intervals (\code{CI_lower}, \code{CI_upper}) and
the p-values for all coefficients apart from the intercept.

The table for nonlinear coefficients include the estimated degrees of freedom
(\code{edf}) and the p-value for each estimate.
}
\examples{
library(APCtools)
library(mgcv)

data(travel)
model <- gam(mainTrip_distance ~ te(age, period) + residence_region +
             household_size + s(household_income), data = travel)

create_modelSummary(list(model), dat = travel)

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
