% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_randomization.R
\name{apa_seg}
\alias{apa_seg}
\title{Calculate the segregation index of NDiv}
\usage{
apa_seg(
  apa_list,
  nsim = 1000,
  save_folder = NULL,
  save_simulations = TRUE,
  overwrite = FALSE,
  buffer_separate = TRUE,
  parallel = TRUE,
  cl = NULL,
  no_cores = 1,
  iseed = 42
)
}
\arguments{
\item{apa_list}{A \code{apa_list}-object that was created with the
[apa_list]-function.}

\item{nsim}{Integer, how many simulation runs will be done.}

\item{save_folder}{If specified, intermediate simulation results and
processing report will be stored in this folder (defaults to NULL).}

\item{save_simulations}{If TRUE (default) and if \code{save_folder} is
specified,  individual simulations will be stored (may consume large
storage capacities).}

\item{overwrite}{If FALSE (default), \code{save_folder} needs to be empty. If
TRUE, all content in \code{save_folder} will be deleted before the new
simulations start.}

\item{buffer_separate}{Should tree locations in the buffer and cores zones
be randomized separately? Defaults to TRUE.}

\item{parallel}{If TRUE (default), parallel processing will be used.}

\item{cl}{If \code{parallel} is TRUE, a Parallel Socket Cluster that was
created with the [parallel::makeCluster()]-function is specified here. If
NULL (default), \code{parallel::makeCluster(no_cores)} will be used.}

\item{no_cores}{The number of cores that will be used for parallel processing
(default is 1). If NULL is specified, \code{parallel::detectCores() - 1}
will be used to automatically use one core less than available.}

\item{iseed}{A seed that will be passed to [parallel::clusterSetRNGStream] to
make simulations reproducible when parallel processing is used (default is
42).}
}
\description{
The segregation index of NDiv assesses how much NDiv deviates from its random
expectation using a randomization approach. Values close to zero indicate a
random distribution of the traits that were used to calculate NDiv, values
larger than zero indicate a regular distribution (stem-wise mixing) and
values smaller than zero indicate a clustered configuration (patch-wise
mixing).
}
\details{
See Glatthorn (2021) for details.
}
\examples{
library(APAtree)
data(tree_enrico, package = "APAtree")
data(plot_enrico, package = "APAtree")

tree_enrico$height_class <- tree_enrico$height > 20

# only calculating an apa_list for two plots and with a coarse resolution of 1 m
# to save time.
apa_list_enrico <- 
  apa_list(plot_dat = subset(plot_enrico, id_plot \%in\% c("5.2", "8.2")), 
           tree_dat = tree_enrico,
           buffer_column = "buffer_geometry",
           core_column = "border_geometry",
           plot_id_column = "id_plot",
           tree_id_column = "id_tree",
           weight_column = "crown_radius_95",
           agg_class_column = c("species", "height_class"),
           res = 10,
           apa_polygon = FALSE)

apa_list_enrico <- 
  apa_ndiv(apa_list_enrico, dis_trait_column = "species")

apa_list_enrico <-
  apa_seg(apa_list_enrico, nsim = 3, parallel = FALSE)

# stand-level segregation index of SpeciesNDiv
apa_list_enrico$plot_dat[, c("id_plot", "seg_species_ndiv")]


}
\references{
{ Glatthorn, Jonas (2021). A spatially explicit index for tree
species or trait diversity at neighborhood and stand level. Ecological
Indicators, 130, 108073. https://doi.org/10.1016/j.ecolind.2021.108073.}
}
