% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.ri.R
\name{met.ri}
\alias{met.ri}
\title{R-Index}
\usage{
met.ri(M, df = NULL, dfid = NULL)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{R-index} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{R-index} if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{R-index} titled 'R-index', if argument \emph{df} is not \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{R-index} if 1) argument \emph{df} is not \emph{NULL}, 2) argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and 3) argument \emph{df} is a list of data frames of same length as argument \emph{M}. The name of the column of each element of the list is adapted according to argument value \emph{binary}.
}
}
\description{
Calculates the node metric R-Index for all vertices.
}
\details{
R-Index of vertex \emph{i} is the outstrength of node \emph{i} divided by the met.strength of node \emph{i}. This node metric aims to measure if an individual is more likely to receive or emit edges.
}
\examples{
met.ri(sim.m)
head(sim.df)
met.ri(sim.m,df=sim.df)
}
\references{
Liao, Z., Sosa, S., Wu, C., & Zhang, P. (2017). The influence of age on wild rhesus macaques' affiliative social interactions. American journal of primatology.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
