% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxon.mann.whitney.R
\name{wilcoxon.mann.whitney}
\alias{wilcoxon.mann.whitney}
\title{Perform Wilcoxon-Mann-Whitney test}
\usage{
wilcoxon.mann.whitney(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  cont.corr = TRUE,
  CI.width = 0.95,
  max.exact.cases = 1000,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.mc = FALSE,
  do.CI = TRUE
)
}
\arguments{
\item{x}{Numeric vector, or factor with same levels as y}

\item{y}{Numeric vector, or factor with same levels as x}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{cont.corr}{Boolean indicating whether or not to use continuity correction (defaults to \code{TRUE})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{wilcoxon.mann.whitney()} performs the Wilcoxon-Mann-Whitney test and is used in chapters 6, 8, 9 and 12 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Examples 6.1 and 6.2 from "Applied Nonparametric Statistical Methods" (5th edition)
wilcoxon.mann.whitney(ch6$groupA, ch6$groupB)

# Exercise 12.4 from "Applied Nonparametric Statistical Methods" (5th edition)
wilcoxon.mann.whitney(ch12$feedback.satisfaction[ch12$PPI.person.2 == "Representative"],
  ch12$feedback.satisfaction[ch12$PPI.person.2 == "Researcher"],
  do.exact = FALSE, do.asymp = TRUE)

}
