% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_12_table_1}
\alias{chapter_12_table_1}
\alias{C12T1}
\alias{Chapter_12_Table_1}
\alias{c12t1}
\title{The data used in Chapter 12, Table 1}
\format{
An object of class \code{data.frame} with 10 rows and 6 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_12_table_1)
}
\description{
The data used in Chapter 12, Table 1
}
\details{
Suppose that a psychologist studying the visual system was interested in determining the extent to which interfering visual stimuli slow the abilityto recognize letters. Subjects are brought into a laboratory and seated in front of a tachistoscope. Subjects are told that they will see either the letter T or the letter I displayed on the screen. In some trials, the letter appears by itself, but in other trials, the target letter is embedded in a group of other letters. This variation in the display consitutes the first factor, which is referred to as noise. The noise factor has two levels -- absent and present. The other factor varied by the experimenter is where in the display the target letter appears. This factor, which is called angle, has three levels. The target letter is either shown at the center of the screen (0 degrees off-center, where the subject has been instructed to fixate), 4 degrees off-center or 8 degrees off-center (in each case, the deviation from the center varies randomly between left and right).
The data in Table 12.1 consist of reaction time scores for 10 participants where each participant contributes 6 scores to the analysis. In particular, each participant is exposed to each of 6 experimental conditions, which are obtained by factorially combining angle (0, 4, and 8) with noise (absent and present). The tests of interest are the omnibus tests within the two-factor within-subjects ANOVA. The dependent measure is reaction time (latency), measured in milliseconds (ms), required by the subject to identify the correct target letter. Each subject has six scores.
}
\section{Variables}{

\describe{
   \item{abs0}{reaction time w/ noise absent, angle 0}
   \item{abs4}{reaction time w/ noise absent, angle 4}
   \item{abs8}{reaction time w/ noise absent, angle 8}
   \item{pres0}{reaction time w/ noise present, angle 0}
   \item{pres4}{reaction time w/ noise present, angle 4}
   \item{pres8}{reaction time w/ noise present, angle 8}
}
}

\section{Synonym}{

C12T1
}

\examples{
# Load the data
data(chapter_12_table_1)

# Or, alternatively load the data as
data(C12T1)

# View the structure
str(chapter_12_table_1)

}
\references{
Maxwell, S. E., Delaney, H. D., \& Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
