% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMAPVoxGenerics.R, R/AMAPVoxGetters.R
\docType{methods}
\name{getPosition}
\alias{getPosition}
\alias{getPosition,VoxelSpace,vector-method}
\alias{getPosition,VoxelSpace,list-method}
\alias{getPosition,VoxelSpace,missing-method}
\title{Gets the x, y, z coordinates of a given voxel.}
\usage{
getPosition(voxelSpace, voxel)

\S4method{getPosition}{VoxelSpace,vector}(voxelSpace, voxel)

\S4method{getPosition}{VoxelSpace,list}(voxelSpace, voxel)

\S4method{getPosition}{VoxelSpace,missing}(voxelSpace, voxel)
}
\arguments{
\item{voxelSpace}{the \code{\link{VoxelSpace-class}} object.}

\item{voxel}{either the voxel index as a \code{c(i, j, k)} vector or a voxel
from the VoxelSpace data.table.}
}
\value{
the x, y, z coordinates of the voxel center.
}
\description{
Gets the x, y, z coordinates of the voxel center. If the voxel
parameter is missing, it returns the positions of all the voxels in the
voxel space.
}
\examples{
# load a voxel file
vox <- readVoxelSpace(
 system.file("extdata", "als_sample.vox", package = "AMAPVox"))

# get position of voxel(i=0, j=0, k=0)
getPosition(vox, c(0, 0, 0))

# get position of 1st voxel in the data.table
getPosition(vox, vox@voxels[1,])

# get positions of every voxel
getPosition(vox)
}
