# ACDC: Analysis of Congruent Diversification Classes

A package for investigating and visualizing the congruence class (Louca & Pennell 2020) of a phylogenetic birth-death model.

## Installation:

The stable version can be installed from CRAN:

    install.packages("ACDC")

The developmental version can be installed from the github repository. The package `devtools` makes this convenient:

    install.packages("devtools")
    library(devtools)
    install_github("afmagee/ACDC")

## Documentation

There is documentation for each function in R (type `?ACDC` in the R-console), as well as a long-form vignette with an [example workflow](https://afmagee.github.io/ACDC/).

### References
* Louca, S., & Pennell, M. W. (2020). Extant timetrees are consistent with a myriad of diversification histories. Nature, 580(7804), 502-505.
