% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_account_users.R
\name{get_account_users}
\alias{get_account_users}
\title{Get All Users in an Account}
\usage{
get_account_users(account_id, client_id, client_secret)
}
\arguments{
\item{account_id}{Account Id granted by the Zoom developer app.}

\item{client_id}{Client Id granted by the Zoom developer app.}

\item{client_secret}{Client secret granted by the Zoom developer app.}
}
\value{
A data frame with the list of all users in the account.
}
\description{
Get all users in a zoom account. The user id is required to get a list of
webinars hosted by a particular user.
}
\examples{
\dontrun{
dat <- get_account_users(your_account_id,
  your_client_id,
  your_client_secret)
}
}
\seealso{
See <https://marketplace.zoom.us/docs/api-reference/zoom-api/> for 
documentation on the Zoom API.
}
