% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgpProblems.R
\name{compileBNF}
\alias{compileBNF}
\title{Compile a BNF.}
\usage{
compileBNF(g, verbose = FALSE)
}
\arguments{
\item{g}{A character string with a BNF.}

\item{verbose}{Boolean. TRUE: Show progress. Default: FALSE.}
}
\value{
A grammar object (list) with the attributes
        \code{name} (the filename of the grammar),
        \code{ST} (symbol table),
        \code{PT} (production table),
        \code{Start} (the start symbol of the grammar),
        and \code{SPT} (the short production table).
}
\description{
\code{compileBNF()} produces a context-free grammar
              from its specification in Backus-Naur form (BNF).
              Warning: No error checking implemented.
}
\details{
A grammar consists of the symbol table \code{ST}, the production
         table \code{PT}, the start symbol \code{Start},
         and the short production
         table \code{SPT}. An example BNF is provided 
         by \code{booleanGrammar()}.

The function performs the following steps:
 \enumerate{
 \item Make the symbol table. 
 \item Make the production table.
 \item Extract the start symbol.
 \item Compile a short production table.
 \item Return the grammar.}

For a full documentation, see <https://CRAN.R-project.org/package=xegaBNF>
}
\examples{
g<-compileBNF(booleanGrammar())
g$ST
g$PT
g$Start
g$SPT
}
\seealso{
Other Grammar: 
\code{\link{booleanGrammar}()}
}
\concept{Grammar}
