% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_surnames.R
\name{merge_surnames}
\alias{merge_surnames}
\title{Surname probability merging function.}
\usage{
merge_surnames(
  voter.file,
  surname.year = 2020,
  name.data,
  clean.surname = TRUE,
  impute.missing = TRUE
)
}
\arguments{
\item{voter.file}{An object of class \code{data.frame}. Must contain a field
named 'surname' containing list of surnames to be merged with Census lists.}

\item{surname.year}{An object of class \code{numeric} indicating which year
Census Surname List is from. Accepted values are \code{2010} and \code{2000}.
Default is \code{2020}.}

\item{name.data}{An object of class \code{data.frame}. Must contain a leading
column of surnames, and 5 subsequent columns, with Pr(Race | Surname) for each
of the five major racial categories.}

\item{clean.surname}{A \code{TRUE}/\code{FALSE} object. If \code{TRUE},
any surnames in \code{\var{voter.file}} that cannot initially be matched
to surname lists will be cleaned, according to U.S. Census specifications,
in order to increase the chance of finding a match. Default is \code{TRUE}.}

\item{impute.missing}{A \code{TRUE}/\code{FALSE} object. If \code{TRUE},
race/ethnicity probabilities will be imputed for unmatched names using
race/ethnicity distribution for all other names (i.e., not on Census List).
Default is \code{TRUE}.}
}
\value{
Output will be an object of class \code{data.frame}. It will
consist of the original user-input data with additional columns that
specify the part of the name matched with Census data (\code{\var{surname.match}}),
and the probabilities Pr(Race | Surname) for each racial group
(\code{\var{p_whi}} for White, \code{\var{p_bla}} for Black,
\code{\var{p_his}} for Hispanic/Latino,
\code{\var{p_asi}} for Asian and Pacific Islander, and
\code{\var{p_oth}} for Other/Mixed).
#'
}
\description{
\code{merge_surnames} merges surnames in user-input dataset with corresponding
race/ethnicity probabilities from U.S. Census Surname List and Spanish Surname List.
}
\details{
This function allows users to match surnames in their dataset with the U.S.
Census Surname List (from 2000 or 2010) and Spanish Surname List to obtain
Pr(Race | Surname) for each of the five major racial groups.

By default, the function matches surnames to the Census list as follows:
\enumerate{
\item Search raw surnames in Census surname list;
\item Remove any punctuation and search again;
\item Remove any spaces and search again;
\item Remove suffixes (e.g., Jr) and search again;
\item Split double-barreled surnames into two parts and search first part of name;
\item Split double-barreled surnames into two parts and search second part of name;
\item For any remaining names, impute probabilities using distribution
for all names not appearing on Census list.
}

Each step only applies to surnames not matched in a previous ste.
Steps 2 through 7 are not applied if \code{clean.surname} is FALSE.

Note: Any name appearing only on the Spanish Surname List is assigned a
probability of 1 for Hispanics/Latinos and 0 for all other racial groups.
}
\examples{
data(voters)
\dontrun{try(merge_surnames(voters))}

}
\keyword{internal}
